﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using static POA.PlayerOnePWSDK.PlayerOneFilterWheelDLL;

//Please put the "PlayerOnePW.dll" and "PlayerOnePW_x64.dll" into the executable directory(bin/debug, bin/release)
//----->For more information, please read 'PlayerOnePW.h'

namespace FilterWheelTestDemo
{
    class Program
    {
        static void Main(string[] args)
        {

            Console.WriteLine("API Ver: {0}", POAGetPWAPIVer());
            Console.WriteLine("SDK Ver: {0}", POAGetPWSDKVer());

            Console.WriteLine("----------------------------------------");
            int wheelCount = POAGetPWCount();
            Console.WriteLine("wheel count: {0}", wheelCount);

            if(wheelCount <= 0)
            {
                return;
            }

            // get all connected wheels properties
            PWErrors error;
            List<PWProperties> wheelPropList = new List<PWProperties>();
            for (int i = 0; i < wheelCount; i++) // get all wheel properties
            {
                Console.WriteLine("get wheel property, index: {0}", i);
                PWProperties wheelProp;
                error = POAGetPWProperties(i, out wheelProp); //get wheel properties

                if (error != PWErrors.PW_OK)
                {
                    Console.WriteLine("Get wheel properties failed, index: {0}, error code: {1}", i, POAGetPWErrorString(error)); // show the error string
                    continue;
                }
                else
                {
                    Console.WriteLine("Handle: {0}, Name: {1}, Position Count: {2}, SN: {3}", wheelProp.Handle, wheelProp.Name, wheelProp.PositionCount, wheelProp.SN); //print wheel properties
                }

                wheelPropList.Add(wheelProp);
            }

            Console.WriteLine("----------------------------------------");
            //operate the first wheel
            int handle, positionCount, gotoPosition;
            handle = wheelPropList[0].Handle;
            positionCount = wheelPropList[0].PositionCount;

            error = POAOpenPW(handle);
            if (error != PWErrors.PW_OK)
            {
                Console.WriteLine("open wheel failed, error: {0}", POAGetPWErrorString(error)); // show the error string
                return;
            }

            Console.WriteLine("open wheel OK, Handle: {0}", handle);

            // NOTE: When first opened successfully, wheel will goto 1st position
            // detect wheel is moving
            PWState wheelState = PWState.PW_STATE_OPENED;
            while (true)
            {
                POAGetPWState(handle, out wheelState);
                if(wheelState != PWState.PW_STATE_MOVING) //waiting for wheel stop moving
                { break; }
            }

            Console.WriteLine("----------------------------------------");
            error = POAGetCurrentPosition(handle, out gotoPosition); // get wheel current position
            Console.WriteLine("get current position, error: {0}", POAGetPWErrorString(error));
            Console.WriteLine("wheel current position: {0}", gotoPosition+1); // position is index, start from 0

            Console.WriteLine("----------------------------------------");
            Console.WriteLine("start wheel goto test...");
            bool isPosIncreased = true;
            while (true)
            {
                while (true)
                {
                    POAGetPWState(handle, out wheelState);
                    if (wheelState != PWState.PW_STATE_MOVING) //waiting for wheel stop moving
                    { break; }
                }

                if (isPosIncreased)
                { gotoPosition += 1; }
                else
                { gotoPosition -= 1; }

                if (gotoPosition < 0)
                { break; }
                else if (gotoPosition >= positionCount)
                {
                    isPosIncreased = false;
                    gotoPosition = positionCount - 1;
                    continue;
                }

                Console.WriteLine("wheel is moving to {0} position...", gotoPosition + 1);
                error = POAGotoPosition(handle, gotoPosition);
                Console.WriteLine("goto position, error: {0}", POAGetPWErrorString(error));
            }

            Console.WriteLine("----------------------------------------");
            // set and get one way
            error = POASetOneWay(handle, true); // enable one-way
            Console.WriteLine("set one way, error: {0}", POAGetPWErrorString(error));

            bool isOneWay = false;
            error = POAGetOneWay(handle, out isOneWay);
            Console.WriteLine("get one way, error: {0}", POAGetPWErrorString(error));
            Console.WriteLine("is one way: {0}", isOneWay);

            Console.WriteLine("----------------------------------------");
            //set filter alias and focus offset
            for (int pos = 0; pos < positionCount; pos++)
            {
                Console.WriteLine("set filter alias and focus offset, position: {0}", pos);
                string strFilterAlias = string.Format("csR_{0}", pos); // max length is MAX_FILTER_NAME_LEN
                error = POASetPWFilterAlias(handle, pos, strFilterAlias); // if want to clear alias, POASetPWFilterAlias(handle, pos, "")
                Console.WriteLine("set filter alias, error: {0}", POAGetPWErrorString(error));
                for (int time = 0; time < 100000; time++) ; // recommended, similar to the sleep() function, relieve pressure on filter wheel hardware

                int focus_offset = 1000 + pos;
                error = POASetPWFocusOffset(handle, pos, focus_offset); // want to set no focus offset, POASetPWFocusOffset(handle, pos, 0)
                Console.WriteLine("set focus offset, error: {0}", POAGetPWErrorString(error));
                for (int time = 0; time < 100000; time++) ; // recommended, similar to the sleep() function, relieve pressure on filter wheel hardware
            }

            Console.WriteLine("----------------------------------------");
            //get filter alias and focus offset
            for (int pos = 0; pos < positionCount; pos++)
            {
                Console.WriteLine("get filter alias and focus offset, position: {0}", pos);
                string strFilterAlias;
                error = POAGetPWFilterAlias(handle, pos, out strFilterAlias);
                Console.WriteLine("get filter alias, error: {0}", POAGetPWErrorString(error));
                Console.WriteLine("the filter alias is: {0}", strFilterAlias);
                for (int time = 0; time < 100000; time++) ; // recommended, similar to the sleep() function, relieve pressure on filter wheel hardware

                int focus_offset = 0;
                error = POAGetPWFocusOffset(handle, pos, out focus_offset);
                Console.WriteLine("get focus offset, error: {0}", POAGetPWErrorString(error));             
                Console.WriteLine("the focus offset is: {0}", focus_offset);
                for (int time = 0; time < 100000; time++) ; // recommended, similar to the sleep() function, relieve pressure on filter wheel hardware
            }

            Console.WriteLine("----------------------------------------");
            // set custom name for wheel
            string strCustomName = string.Format("PW_{0}P", positionCount); // max length is MAX_FILTER_NAME_LEN
            error = POASetPWCustomName(handle, strCustomName);
            Console.WriteLine("set wheel custom name, error: {0}", POAGetPWErrorString(error));
            // get custom name for wheel
            strCustomName = "";
            error = POAGetPWCustomName(handle, out strCustomName);
            Console.WriteLine("get wheel custom name, error: {0}", POAGetPWErrorString(error));
            Console.WriteLine("the custom name is: {0}", strCustomName);
            PWProperties prop;
            POAGetPWPropertiesByHandle(handle, out prop);
            Console.WriteLine("the name of wheel show as: {0}", prop.Name);

            Console.WriteLine("----------------------------------------");
            //if the wheel has an error, please try resetting it
            error = POAResetPW(handle);
            Console.WriteLine("reset wheel:, error: {0}", POAGetPWErrorString(error));
            Console.WriteLine("wait for the reset to complete...");
            wheelState = PWState.PW_STATE_OPENED;
            while (true)
            {
                POAGetPWState(handle, out wheelState);
                if (wheelState != PWState.PW_STATE_MOVING) //waiting for wheel stop moving
                { break; }
            }

            error = POAClosePW(handle);
            Console.WriteLine("close the wheel:, error: {0}", POAGetPWErrorString(error));
        }
    }
}
